/*
 * Decompiled with CFR 0.152.
 */
package dk.skat.spilkontrol.validator.utils;

import dk.skat.spilkontrol.validator.utils.FirstXmlElementReader;
import dk.skat.spilkontrol.validator.utils.ManualClosedInputStream;
import dk.skat.spilkontrol.validator.utils.StopXmlSaxParserException;
import dk.skat.spilkontrol.validator.utils.StringUtil;
import dk.skat.spilkontrol.validator.utils.ValidatorXMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ZipFileValidator {
    private FirstXmlElementReader xmlReader = new FirstXmlElementReader();
    private final Map<String, Schema> schemas = new HashMap<String, Schema>();
    private Map<String, Integer> fileErrorMap = new HashMap<String, Integer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFileValidator.class);
    public static int errorCount;

    public boolean validate(String schemaVersion, ZipInputStream inputZipStream) {
        block20: {
            ZipEntry zipEntry = null;
            try {
                try {
                    int validatedFileCount = 0;
                    while ((zipEntry = inputZipStream.getNextEntry()) != null) {
                        if (!zipEntry.isDirectory()) {
                            LOGGER.info("Validating file: " + zipEntry.getName());
                            this.validateZipFile(schemaVersion, inputZipStream, zipEntry.getName());
                            if (errorCount != 0) {
                                this.fileErrorMap.put(zipEntry.getName(), errorCount);
                            }
                            ++validatedFileCount;
                            continue;
                        }
                        inputZipStream.closeEntry();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n***Summary***: \n");
                    sb.append(String.valueOf(validatedFileCount) + " files were processed \n");
                    if (this.fileErrorMap.isEmpty()) {
                        sb.append("No errors were found");
                    } else {
                        for (Map.Entry<String, Integer> pairs : this.fileErrorMap.entrySet()) {
                            if (pairs.getValue() == 0) continue;
                            sb.append("File '" + pairs.getKey() + "' contains " + pairs.getValue() + " errors \n");
                        }
                    }
                    LOGGER.info(sb.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputZipStream != null) {
                        try {
                            inputZipStream.close();
                        }
                        catch (Exception e2) {
                            LOGGER.error("zipStream.closeStream() failed");
                        }
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (inputZipStream != null) {
                    try {
                        inputZipStream.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("zipStream.closeStream() failed");
                    }
                }
                throw throwable;
            }
            if (inputZipStream != null) {
                try {
                    inputZipStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("zipStream.closeStream() failed");
                }
            }
        }
        return errorCount == 0;
    }

    public void validateZipFile(String schemaVersion, ZipInputStream inputStream, String fileName) {
        ManualClosedInputStream is = new ManualClosedInputStream(inputStream);
        errorCount = 0;
        try {
            String rootTagName = this.findRootTagName(is);
            SAXParser saxParser = this.getValidatingParser(is, rootTagName, schemaVersion);
            saxParser.parse((InputStream)is, (DefaultHandler)new ValidatorXMLHandler());
        }
        catch (SAXException e) {
            ++errorCount;
            LOGGER.error(e.getMessage());
        }
        catch (IOException e) {
            ++errorCount;
            LOGGER.error(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            ++errorCount;
            LOGGER.error(e.getMessage());
        }
    }

    public SAXParser getValidatingParser(InputStream is, String rootTagName, String schemaVersion) throws SAXException, IOException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            Schema schema = this.getSchemaForXmlFile(schemaVersion, rootTagName);
            saxParserFactory.setSchema(schema);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            return saxParser;
        }
        catch (Exception e) {
            throw new StopXmlSaxParserException("Error configuring validating XML parser", e);
        }
    }

    private Schema getSchemaForXmlFile(String schemaVersion, String rootTagName) throws SAXException {
        Schema schema = null;
        if (this.schemas.containsKey(rootTagName)) {
            schema = this.schemas.get(rootTagName);
        } else {
            String pathToType = "";
            pathToType = schemaVersion.matches("[0-9]+") ? String.format("/v%1s/view/%2$sType.xsd", schemaVersion, StringUtil.replaceDanishChars(rootTagName)) : String.format("/%1s/view/%2$sType.xsd", schemaVersion, StringUtil.replaceDanishChars(rootTagName));
            URL xsdUrl = ZipFileValidator.class.getResource(pathToType);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = schemaFactory.newSchema(xsdUrl);
            this.schemas.put(rootTagName, schema);
        }
        return schema;
    }

    public String findRootTagName(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        is.mark(1000000);
        try {
            saxParser.parse(is, (DefaultHandler)this.xmlReader);
        }
        catch (StopXmlSaxParserException stopXmlSaxParserException) {
            // empty catch block
        }
        is.reset();
        return this.xmlReader.getFirstTagQName();
    }
}

