/*
 * Decompiled with CFR 0.152.
 */
package dk.skat.spilkontrol.validator.utils;

import dk.skat.spilkontrol.validator.utils.ZipFileValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorXMLHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatorXMLHandler.class);

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        super.endElement(arg0, arg1, arg2);
    }

    public void error(SAXParseException e) throws SAXException {
        this.printInfo(e, "Error");
        ++ZipFileValidator.errorCount;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.printInfo(e, "Fatal error");
        ++ZipFileValidator.errorCount;
    }

    private void printInfo(SAXParseException e, String errorType) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n   " + errorType + "\n");
        sb.append("   Line number: " + e.getLineNumber() + "\n");
        sb.append("   Column number: " + e.getColumnNumber() + "\n");
        sb.append("   Message: " + e.getMessage() + "\n");
        LOGGER.error(sb.toString());
    }
}

