/*
 * Decompiled with CFR 0.152.
 */
package dk.skat.spilkontrol.validator;

import dk.skat.spilkontrol.validator.utils.ZipFileValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final int CMDLINE_ARGS_LENGTH = 4;
    private static final String FILE = "-file";
    private static final String VERSION = "-version";
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        Main.validateParameters(args);
        String schemaVersion = args[1];
        String pathToFile = args[3];
        ZipInputStream inputZipStream = null;
        try {
            inputZipStream = new ZipInputStream(new FileInputStream(new File(pathToFile)));
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File " + pathToFile + " not found !!!");
            System.exit(1);
        }
        LOGGER.info(" >>> Validator started for file " + pathToFile + " >>>");
        ZipFileValidator zipFileValidator = new ZipFileValidator();
        boolean success = zipFileValidator.validate(schemaVersion, inputZipStream);
        LOGGER.info(" <<< Validator ended for file " + pathToFile + " <<<");
        if (success) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }

    private static void validateParameters(String[] args) {
        if (args.length == 4) {
            String schema;
            if (!args[0].equals(VERSION)) {
                LOGGER.error("Specify version argument correctly: standard-record-validator.cmd -version 1 -file pathToFile");
                System.exit(1);
            }
            if (!((schema = args[1]).equals("1") || schema.equals("2") || schema.equals("3") || schema.equals("monopol"))) {
                LOGGER.error("Invalid version. Schema version should be '1' or '2' or '3' or 'monopol'");
                System.exit(1);
            }
            if (!args[2].equals(FILE)) {
                LOGGER.error("Specify file argument correctly: standard-record-validator.cmd -version 1 -file pathToFile");
                System.exit(1);
            }
            if (args[3] == null) {
                LOGGER.error("Path to file should be specified");
                System.exit(1);
            }
        } else {
            LOGGER.error("Specify correct number of arguments: standard-record-validator.cmd -version 1 -file pathToFile");
            System.exit(1);
        }
    }
}

